/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax;

/**
 * Interface that exports the setting and getting of properties on a device. 
 */
public interface Properties
{
   /**
    * Interface to return a collection of properties supported by the device.
    * @exception DataException thrown when the properties in the device are incompatible
    */ 
   public PropertiesCollection getProperties() throws DataException;

   /**
    * Interface to set the given properties collection into the device. Works under the assumption
    * that the properties collection was generated LOCALLY and is a request for options.
    * @exception DataException thrown when trying to set incompatible properties collections
    */
   public void setProperties(PropertiesCollection pc) throws DataException;

   /**
    * Interface to set the given properties collection into the device. WOrks under the 
    * assumption that this is the properties collection of the peer.
    */
   public void setPeerProperties(PropertiesCollection pc) throws DataException;
}
